/* --------------------------------------------------------------------------
 * SimpleOpenNI User3d Test
 * --------------------------------------------------------------------------
 * Processing Wrapper for the OpenNI/Kinect library
 * http://code.google.com/p/simple-openni
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner / Interaction Design / zhdk / http://iad.zhdk.ch/
 * date:  02/16/2011 (m/d/y)
 * ----------------------------------------------------------------------------
 * this demos is at the moment only for 1 user, will be implemented later
 * ----------------------------------------------------------------------------
 */

// Basically to rotate around the object's origin you first need to translate() to the origin - i.e. its x/y position 
// (this is demonstrated in the rotateX Reference page) - and you'll need to wrap this action in a pushMatrix()/popMatrix() 
// to avoid affecting other objects...  but you're also going to need to perform the drawing operation from within the Matrix 
// transformation in order for the rendered shape to be affected.  That might mean moving the code to your makeShape() method 
// and adding a condition to generate the spin only when the mouse is over the object, rather than using your beginSpin() method...  
// In fact I'd say the switchOn and beginSpin methods are a little superfluous.  I know some OOP purists would suggest to split 
// to many simple methods, but sometimes this creates other issues you need to work around.
//
// You might also want to reconsider the way you calculate selected() - i.e. mouseOver.  Since the object's x/y coordinates 
// are at its centre from what I can see you're only registering mouseOver on the bottom right of the shape.  A simpler approach 
// might be to check the distance from the object's centre.

import wblut.hemesh.modifiers.*;
import wblut.core.processing.*;
import wblut.hemesh.creators.*;
import wblut.hemesh.core.*;

import processing.opengl.*;

import saito.objloader.*;
import toxi.geom.*;

HE_Mesh mesh;
WB_Render render;

import SimpleOpenNI.*;

// SimpleOpenNI context;
float        zoomF =0.5f;
float        rotX = radians(180);  // by default rotate the whole scene 180deg around the x-axis, 
                                   // the data from openni comes upside down
float        rotY = radians(0);
float        rotZ = radians(0);
float        locrotX = radians(180); // for the hand gesture controls RWH 
float        locrotY = radians(0);   // for the hand gesture controls RWH 
float        locrotZ = radians(00);  // for the hand gesture controls RWH 

boolean      autoCalib=true;

PVector      bodyCenter = new PVector();
PVector      bodyDir = new PVector();

PImage       fakeFloor; 
  
void setup2()
{
  size(1024,768,P3D);  // strange, get drawing error in the cameraFrustum if i use P3D, in opengl there is no problem
  context = new SimpleOpenNI(this);
  initOSC();  
  rwh_read_file();
  // disable mirror
  context.setMirror(false);

  // enable depthMap generation 
  if(context.enableDepth() == false)
  {
     println("Can't open the depthMap, maybe the camera is not connected!"); 
     exit();
     return;
  }

  // enable skeleton generation for all joints
  context.enableUser(SimpleOpenNI.SKEL_PROFILE_ALL);
  // RWH: what are some other options here???  

  // enable hands + gesture generation
  context.enableGesture();
  context.enableHands();
  
  // add focus gestures  / here i do have some problems on the mac, i only recognize raiseHand ? Maybe cpu performance ?
  context.addGesture("Wave");
  context.addGesture("Click");
  context.addGesture("RaiseHand");
  
  // set how smooth the hand capturing should be
  //context.setSmoothingHands(.5);

  stroke(255,255,255);
  smooth();  
  perspective(radians(45),
              float(width)/float(height),
              10,150000);
  fakeFloor = createFloor(color(200));
  
  createMesh();

  HEM_SphereInversion modifier=new HEM_SphereInversion();
  modifier.setRadius(200);
  modifier.setCenter(50, 0, 0);
  modifier.setCutoff(1000);
  modifier.setLinear(false);
  mesh.modify(modifier);

  render=new WB_Render(this);
  
}

void createMesh() {
  HEC_Cube creator=new HEC_Cube(300, 1,1, 1);
  mesh=new HE_Mesh(creator);
  mesh.modify(new HEM_Extrude().setDistance(300));
  mesh=new HE_Mesh(new HEC_FromFrame().setFrame(mesh).setMaximumStrutLength(20));
}

void draw2()
{
  // update the cam
  context.update();
  // println("at update()"); 
  // background(0,0,0);
  
  background(200);
  
  // Draw the floor image in an inclined plane
  beginShape();
    texture(fakeFloor);
    vertex(-width,0.75*height,-300,0,0);
    vertex(2*width,0.75*height,-300,width,0);
    vertex(width,height,0,width,height);
    vertex(0,height,0,0,height);
  endShape();
  
  // set the scene pos
  translate(width/2, height/2, 0);
  rotateX(rotX);
  rotateY(rotY);
  scale(zoomF);
  
  int[]   depthMap = context.depthMap();
  int     steps   = 3;  // to speed up the drawing, draw every third point
  int     index;
  PVector realWorldPoint;
 
  directionalLight(255, 255, 255, 1, 1, -1);
  directionalLight(127, 127, 127, -1, -1, 1);
  // translate(400, 400, 0);
  // rotateY(mouseX*1.0f/width*TWO_PI);
  // rotateX(mouseY*1.0f/height*TWO_PI);
  fill(255);
  noStroke();
  render.drawFaces(mesh);
  stroke(0);
  render.drawEdges(mesh);
 
  translate(0,0,-1000);  // set the rotation center of the scene 1000 infront of the camera

  stroke(100); 
  for(int y=0;y < context.depthHeight();y+=steps)
  {
    for(int x=0;x < context.depthWidth();x+=steps)
    {
      index = x + y * context.depthWidth();
      if(depthMap[index] > 0)
      { 
        // draw the projected point
        realWorldPoint = context.depthMapRealWorld()[index];
        point(realWorldPoint.x,realWorldPoint.y,realWorldPoint.z);
      }
    } 
  } 
  
  // draw the skeleton if it's available
  int[] userList = context.getUsers();
  for(int i=0;i<userList.length;i++)
  {
    if(context.isTrackingSkeleton(userList[i]))
      drawSkeleton(userList[i]);
      
      // RWH
      PVector jointPos1 = new PVector();
      PVector jointPos2 = new PVector();
      float  confidence;
      int userId = userList[i]; 

      // stroke(0,230,225,50); // stroked sphere looks crappy 
      noStroke();
      fill(0,230,225,45);
      
      // get left and right hands  
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_LEFT_HAND,jointPos1); 
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_RIGHT_HAND,jointPos2); 
      // get the "sternum" coords 
      
      // System.out.println("hi Pos1 Pos2 user length"+jointPos1 + jointPos2 + userList.length);
      
      pushMatrix();	
      translate(jointPos1.x, jointPos1.y, jointPos1.z);
      sphere(25);
      popMatrix();			    
      
      pushMatrix();
      translate(jointPos2.x, jointPos2.y, jointPos2.z);
      sphere(25);
      popMatrix();
      // line(jointPos1.x, jointPos1.y, jointPos1.z, jointPos2.x, jointPos2.y, jointPos2.z);
      
      pushMatrix(); // Outer-nested for hand controls 
      
      if (((jointPos1.z-jointPos2.z) < -10) && ((jointPos1.z-jointPos2.z) > -30)) {
        locrotX += 0.1f;
        rotateX(locrotX);
      } else if (((jointPos1.z-jointPos2.z) > 10) && ((jointPos1.z-jointPos2.z) < 30)) {
        locrotX -= 0.1f;
        rotateX(locrotX);
      }
      float mydiff = jointPos1.z-jointPos2.z; 
      System.out.println("hey buddy!! jointPos1.z-jointPos2.z" + mydiff +" "+locrotX); 
      
//      if (((jointPos1.z-jointPos2.z) < -10) && ((jointPos1.z-jointPos2.z) > -30)) {
//        locrotX += 0.1f;
//        rotateX(locrotX);
//      } else if (((jointPos1.z-jointPos2.z) > 10) && ((jointPos1.z-jointPos2.z) < 30)) {
//        locrotX -= 0.1f;
//        rotateX(locrotX);
//      }
//      float mydiff = jointPos1.z-jointPos2.z; 
//      System.out.println("hey buddy!! jointPos1.z-jointPos2.z" + mydiff +" "+locrotX); 
      
      // draw the connected thingies i.e. http://forum.processing.org/topic/translating-and-rotating-individual-objects-in-a-2d-array
      // pushMatrix(); 
      noStroke(); 
      PVector mPos1 = new PVector(); PVector mPos2 = new PVector(); PVector mPos3 = new PVector(); PVector mPos4 = new PVector(); PVector mPos5 = new PVector();
      mPos1.x = -20; mPos1.y = -20; mPos1.z = -16; mPos2.x = 32; mPos2.y = 28; mPos2.z = -15; mPos3.x = 4; mPos3.y = 20; mPos3.z = 29; mPos4.x = -30; mPos4.y = -37; mPos4.z = -15;
      mPos5.x = 36; mPos5.y = -30; mPos5.z = 25; 
      
      translate(0,0,100);
      fill(0,255,68,200); // light green 
      translate (mPos1.x, mPos1.y, mPos1.z); 
      sphere(13);
      
      translate(0,0,100);
      fill(0,230,255,200); // light blue 
      translate (mPos2.x, mPos2.y, mPos2.z); 
      sphere(14);

      translate(0,0,100);
      fill(255,0,239,200); // magenta-ish
      translate (mPos3.x, mPos3.y, mPos3.z); 
      sphere(14);

      translate(0,0,100);
      fill(248,255,47,200); // yellow
      translate (mPos4.x, mPos4.y, mPos4.z); 
      sphere(16);

      translate(0,0,100);
      fill(12,13,0,200); // black
      translate (mPos5.x, mPos5.y, mPos5.z); 
      sphere(15);
      
      line(mPos1.x, mPos1.y, mPos1.z, mPos2.x, mPos2.y, mPos2.z); 
      
      translate(0,0,-400);
      // popMatrix();
      
      popMatrix(); // Outer-nested 
  }
  // draw the kinect cam
  // context.drawCamFrustum();  /// gawd that was UGLY  
}

// DEAD!  
//      if (userList.length > 1) {
//        userId = userList[1];
//        confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_TORSO,jointPos2); 
//
//        float mydistance = sqrt(pow(jointPos1.x-jointPos2.x,2) + pow(jointPos1.y-jointPos2.y,2) + pow(jointPos1.z-jointPos2.z,2));
//        translate(jointPos2.x, jointPos2.y, jointPos2.z);
//        sphere(1/mydistance + 30); // double check this for realisticness with more than one person 
//        translate(jointPos1.x, jointPos1.y, jointPos1.z);
//        sphere(1/mydistance + 30);
//        
//      } else {
//        // Just one skeleton  
//        translate(jointPos1.x, jointPos1.y, jointPos1.z);
//        sphere(130);
//      }

//      createMesh();
//
//      HEM_SphereInversion modifier=new HEM_SphereInversion();
//      modifier.setRadius(200);
//      modifier.setCenter(50, 0, 0);
////      modifier.setCenter(jointPos2.x, jointPos2.y, jointPos2.z);
//      modifier.setCutoff(1000);
//      modifier.setLinear(false);
//      mesh.modify(modifier);
//
//      render=new WB_Render(this);

      // cilinder(Vec3D p1, Vec3D p2, float rad1, float rad2, color col, float frac){
      // cilinder( (Vec3D) jointPos1, (Vec3D) jointPos2, 60, 60, color(255), 0.2);  
      // Vec3D myvec1 = new Vec3D(jointPos1.x, jointPos1.y, jointPos1.z);
      // Vec3D myvec2 = new Vec3D(jointPos1.x, jointPos1.y, jointPos1.z);
      // cilinder( myvec1, myvec2, 60, 60, color(255), 0.2 );  


// draw the skeleton with the selected joints
void drawSkeleton(int userId)
{
  strokeWeight(3);

  // to get the 3d joint data
  drawLimb(userId, SimpleOpenNI.SKEL_HEAD, SimpleOpenNI.SKEL_NECK);

  drawLimb(userId, SimpleOpenNI.SKEL_NECK, SimpleOpenNI.SKEL_LEFT_SHOULDER);
  drawLimb(userId, SimpleOpenNI.SKEL_LEFT_SHOULDER, SimpleOpenNI.SKEL_LEFT_ELBOW);
  drawLimb(userId, SimpleOpenNI.SKEL_LEFT_ELBOW, SimpleOpenNI.SKEL_LEFT_HAND);

  drawLimb(userId, SimpleOpenNI.SKEL_NECK, SimpleOpenNI.SKEL_RIGHT_SHOULDER);
  drawLimb(userId, SimpleOpenNI.SKEL_RIGHT_SHOULDER, SimpleOpenNI.SKEL_RIGHT_ELBOW);
  drawLimb(userId, SimpleOpenNI.SKEL_RIGHT_ELBOW, SimpleOpenNI.SKEL_RIGHT_HAND);

  drawLimb(userId, SimpleOpenNI.SKEL_LEFT_SHOULDER, SimpleOpenNI.SKEL_TORSO);
  drawLimb(userId, SimpleOpenNI.SKEL_RIGHT_SHOULDER, SimpleOpenNI.SKEL_TORSO);

  drawLimb(userId, SimpleOpenNI.SKEL_TORSO, SimpleOpenNI.SKEL_LEFT_HIP);
  drawLimb(userId, SimpleOpenNI.SKEL_LEFT_HIP, SimpleOpenNI.SKEL_LEFT_KNEE);
  drawLimb(userId, SimpleOpenNI.SKEL_LEFT_KNEE, SimpleOpenNI.SKEL_LEFT_FOOT);

  drawLimb(userId, SimpleOpenNI.SKEL_TORSO, SimpleOpenNI.SKEL_RIGHT_HIP);
  drawLimb(userId, SimpleOpenNI.SKEL_RIGHT_HIP, SimpleOpenNI.SKEL_RIGHT_KNEE);
  drawLimb(userId, SimpleOpenNI.SKEL_RIGHT_KNEE, SimpleOpenNI.SKEL_RIGHT_FOOT);  

  // draw body direction
  getBodyDirection(userId,bodyCenter,bodyDir);
  // System.out.println("888rwh: "+bodyCenter);  //  X is left(+) right(-); Y is up down; Z is forward(0-600) towards sensor back is away from sensor (2000) 
  bodyDir.mult(200);  // 200mm length
  bodyDir.add(bodyCenter);
  
  stroke(255,200,200);
  line(bodyCenter.x,bodyCenter.y,bodyCenter.z,
       bodyDir.x,bodyDir.y,bodyDir.z);

  strokeWeight(1);
 
}

void drawLimb(int userId,int jointType1,int jointType2)
{
  PVector jointPos1 = new PVector();
  PVector jointPos2 = new PVector();
  float  confidence;
  
  // draw the joint position
  confidence = context.getJointPositionSkeleton(userId,jointType1,jointPos1);
  confidence = context.getJointPositionSkeleton(userId,jointType2,jointPos2);

  stroke(255,0,0,confidence * 200 + 55);
  line(jointPos1.x,jointPos1.y,jointPos1.z,
       jointPos2.x,jointPos2.y,jointPos2.z);
  
  drawJointOrientation(userId,jointType1,jointPos1,50);
}

void drawJointOrientation(int userId,int jointType,PVector pos,float length)
{
  // draw the joint orientation  
  PMatrix3D  orientation = new PMatrix3D();
  float confidence = context.getJointOrientationSkeleton(userId,jointType,orientation);
  if(confidence < 0.001f) 
    // nothing to draw, orientation data is useless
    return;
    
  pushMatrix();
    translate(pos.x,pos.y,pos.z);
    
    // set the local coordsys
    applyMatrix(orientation);
    
    // coordsys lines are 100mm long
    // x - r
    stroke(255,0,0,confidence * 200 + 55);
    line(0,0,0,
         length,0,0);
    // y - g
    stroke(0,255,0,confidence * 200 + 55);
    line(0,0,0,
         0,length,0);
    // z - b    
    stroke(0,0,255,confidence * 200 + 55);
    line(0,0,0,
         0,0,length);
  popMatrix();
}

// -----------------------------------------------------------------
// SimpleOpenNI user events

void onNewUser(int userId)
{
  println("onNewUser - userId: " + userId);
  println("  start pose detection");
  
  if(autoCalib)
    context.requestCalibrationSkeleton(userId,true);
  else    
    context.startPoseDetection("Psi",userId);
}

void onLostUser(int userId)
{
  println("onLostUser - userId: " + userId);
}

void onExitUser(int userId)
{
  println("onExitUser - userId: " + userId);
}

void onReEnterUser(int userId)
{
  println("onReEnterUser - userId: " + userId);
}


void onStartCalibration(int userId)
{
  println("onStartCalibration - userId: " + userId);
}

void onEndCalibration(int userId, boolean successfull)
{
  println("onEndCalibration - userId: " + userId + ", successfull: " + successfull);
  
  if (successfull) 
  { 
    println("  User calibrated !!!");
    context.startTrackingSkeleton(userId); 
  } 
  else 
  { 
    println("  Failed to calibrate user !!!");
    println("  Start pose detection");
    context.startPoseDetection("Psi",userId);
  }
}

void onStartPose(String pose,int userId)
{
  println("onStartdPose - userId: " + userId + ", pose: " + pose);
  println(" stop pose detection");
  
  context.stopPoseDetection(userId); 
  context.requestCalibrationSkeleton(userId, true);
 
}

void onEndPose(String pose,int userId)
{
  println("onEndPose - userId: " + userId + ", pose: " + pose);
}

// -----------------------------------------------------------------
// Keyboard events

void keyPressed2()
{
  switch(key)
  {
  case ' ':
    context.setMirror(!context.mirror());
    break;
  case 'p':
    System.out.println("  case 'p':");
    printSocialPoints();
    break;
  case 'r':
    System.out.println("  case 'r':");
    rwh_read_file();
    break;
  }
  switch(keyCode)
  {
    case LEFT:
      rotY += 0.1f;
      break;

    case RIGHT:
      // zoom out
      rotY -= 0.1f;
      break;
    case UP:
      if(keyEvent.isShiftDown())
        zoomF += 0.01f;
      else
        rotX += 0.1f;
      break;
    case DOWN:
      if(keyEvent.isShiftDown())
      {
        zoomF -= 0.01f;
        if(zoomF < 0.01)
          zoomF = 0.01;
      }
      else
        rotX -= 0.1f;
      break;
  }
}

void mousePressed() 
{
  if (mouseButton == LEFT){
    
  }
  else {
    // int index = mouseX + mouseY * context.depthWidth();  
    // println("Point3d: " + realWorldMap[index].x + "," + realWorldMap[index].y + "," + realWorldMap[index].z);
    }
}

void mouseDragged() 
{
  if (mouseButton == LEFT){
    // PVector[] realWorldMap = context.depthMapRealWorld();
    // int index = mouseX + mouseY * context.depthWidth();
  }
}

void getBodyDirection(int userId,PVector centerPoint,PVector dir)
{
  PVector jointL = new PVector();
  PVector jointH = new PVector();
  PVector jointR = new PVector();
  float   confidence;
  
  // draw the joint position
  confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_LEFT_SHOULDER,jointL);
  confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_HEAD,jointH);
  confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_RIGHT_SHOULDER,jointR);
  
  // take the neck as the center point
  confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_NECK,centerPoint);
  
  /*  // manually calc the centerPoint
  PVector shoulderDist = PVector.sub(jointL,jointR);
  centerPoint.set(PVector.mult(shoulderDist,.5));
  centerPoint.add(jointR);
  */
  
  PVector up = new PVector();
  PVector left = new PVector();
  
  up.set(PVector.sub(jointH,centerPoint));
  left.set(PVector.sub(jointR,centerPoint));
  
  dir.set(up.cross(left));
  dir.normalize();
}


/*
 * Creates an image with a color gradient in the direction of the y-axis
 */

PImage createFloor(color backgroundColor){
  PImage img = createImage(width,height,RGB);

  for (int y = 0; y < height; y++){
    for (int x = 0; x < width; x++){
      int loc = x + y*width;
      float gradientR = map(y,0,height,red(backgroundColor),40);
      float gradientG = map(y,0,height,green(backgroundColor),40);
      float gradientB = map(y,0,height,blue(backgroundColor),40);
      img.pixels[loc] = color(gradientR-15*y/height,gradientG-15*y/height,gradientB);
    }
  }
  
  return img;
}

